/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIManager;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;
import kz.rating1c.edo.BundleLog;
import kz.rating1c.edo.BundleProvider;
import kz.rating1c.edo.gui.dialog.SignerDialog;
import kz.rating1c.edo.gui.fileChooser.FileChooserDialog;
import kz.rating1c.edo.types.ClientException;
import kz.rating1c.edo.types.KeyInfo;
import kz.rating1c.edo.types.ResponseMessage;
import kz.rating1c.edo.types.StorageInfo;
import org.json.JSONObject;

public class CommonUtils {
    public CommonUtils() {
        String osname = System.getProperty("os.name").toLowerCase();
        try {
            if (osname.contains("mac os")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
    }

    public String getActiveTokens() {
        ResponseMessage res = new ResponseMessage("200");
        res.setResponseObject(new ArrayList());
        for (Storage storage : Storage.values()) {
            try {
                if (KeyStoreUtil.loadSlotList((Storage)storage).isEmpty()) continue;
                ((List)res.getResponseObject()).add(storage.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getJson(res);
    }

    public String getKeyInfo(String storageName) {
        ResponseMessage<KeyInfo> res = new ResponseMessage<KeyInfo>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName);
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.keyInfoTitle");
            titles.put("actionBtn", "button.signerDialog.keyInfo");
            titles.put("header", "label.signerDialog.infoTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, null, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                res.setCode("200");
                res.setResponseObject(new KeyInfo(keyStoreEntry, storageInfo.getAlias()));
            } else {
                res.setMessage("action.canceled");
            }
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            res.setMessage(e.getMessage());
        }
        return this.getJson(res);
    }

    public String signXml(String storageName, String keyTypeValue, String xml, String tbsElementXPath, String signatureParentElementXPath) {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName);
            KNCACertificateType keyType = null;
            try {
                keyType = KNCACertificateType.valueOf((String)keyTypeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.xmlTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                responseMessage.setResponseObject(XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xml, (String)tbsElementXPath, (String)signatureParentElementXPath, (Provider)BundleProvider.KALKANCRYPT.getProvider()));
                responseMessage.setCode("200");
            } else {
                responseMessage.setMessage("action.canceled");
            }
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            responseMessage.setMessage(e.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String createCMSSignatureFromBase64(String storageName, String keyTypeValue, String base64_data, boolean attached) {
        ResponseMessage<String> responseMessage;
        block7: {
            responseMessage = new ResponseMessage<String>("500");
            try {
                StorageInfo storageInfo = new StorageInfo(storageName);
                KNCACertificateType keyType = null;
                try {
                    keyType = KNCACertificateType.valueOf((String)keyTypeValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, String> titles = new HashMap<String, String>();
                titles.put("title", "label.signerDialog.cmsTitle");
                SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
                signerDialog.setVisible(true);
                if (signerDialog.getDoSign()) {
                    KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    CMSSignedData cmsSignedData = CMSUtil.createCAdES((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword(), (byte[])Base64.getDecoder().decode(base64_data), (boolean)attached, (KalkanHashAlgorithm)KalkanHashAlgorithm.HASH_SHA256, (TSAPolicy)TSAPolicy.TSA_RSA, (KNCAServiceRequestMethod)KNCAServiceRequestMethod.GET, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    try {
                        SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                        TSAProfile tsaProfile = new TSAProfile();
                        tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
                        tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
                        tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
                        cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                        responseMessage.setResponseObject(Base64.getEncoder().encodeToString(cmsSignedData.getEncoded()));
                        responseMessage.setCode("200");
                        break block7;
                    }
                    catch (ProviderUtilException var8) {
                        BundleLog.LOG.error(var8.getMessage(), var8);
                        throw new ClientException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434: " + var8.getCode().name());
                    }
                }
                responseMessage.setMessage("action.canceled");
            }
            catch (Exception e) {
                BundleLog.LOG.log(1, e.getMessage(), e);
                responseMessage.setMessage(e.getMessage());
            }
        }
        return this.getJson(responseMessage);
    }

    public String createCMSSignatureFromFile(String storageName, String keyTypeValue, String filePath, boolean attached) {
        try {
            return this.createCMSSignatureFromBase64(storageName, keyTypeValue, this.getBase64FromFile(filePath), attached);
        }
        catch (ClientException e) {
            ResponseMessage responseMessage = new ResponseMessage("500");
            responseMessage.setMessage(e.getMessage());
            return this.getJson(responseMessage);
        }
    }

    public String showFileChooser(String fileExtension, String currentDirectory) {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("500");
        try {
            responseMessage.setResponseObject(this.chooseFile(fileExtension, currentDirectory));
            responseMessage.setCode("200");
        }
        catch (Exception e) {
            responseMessage.setMessage(e.getMessage());
        }
        return this.getJson(responseMessage);
    }

    private String getBase64FromFile(String file_path) throws ClientException {
        try {
            Path path = Paths.get(file_path, new String[0]);
            byte[] fileBytes = Files.readAllBytes(path);
            return Base64.getEncoder().encodeToString(fileBytes);
        }
        catch (IOException e) {
            throw new ClientException("file.not_found");
        }
    }

    private String chooseFile(String fileExt, String currentDirectory) throws ClientException {
        FileChooserDialog fileChooserDialog = new FileChooserDialog(new JFrame(), fileExt, currentDirectory);
        if (fileChooserDialog.getSelectedFilePath() != null) {
            return fileChooserDialog.getSelectedFilePath();
        }
        throw new ClientException("action.canceled");
    }

    private String getJson(Object o) {
        return JSONObject.wrap((Object)o).toString();
    }
}

