/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.function.Function;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.rating1c.edo.BundleLog;
import kz.rating1c.edo.BundleProvider;
import kz.rating1c.edo.CommonUtils;
import kz.rating1c.edo.SignUtils;
import kz.rating1c.edo.types.ResponseMessage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class NCALayerCommonActivator
implements BundleActivator {
    private static final int[] ARRAY_INT = new int[0];
    private static final String[] ARRAY_STRING = new String[0];
    private int keyInfosMaxLength = 20;

    public void start(BundleContext context) throws Exception {
        try {
            BundleLog.LOG.discoverLogService();
            BundleProvider.KALKANCRYPT.discoverProviderService();
            SignUtils signUtils = new SignUtils();
            this.getKeyInfoService(context, signUtils);
            this.getKeyInfoSetterService(context, signUtils);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("module", "kz.rating1c.edo.signUtils");
            context.registerService(ModuleService.class.getName(), (Object)this.getModuleService(signUtils), props);
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            throw new Exception("Can not start bundle kz.rating1c.edo!");
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private ModuleService getModuleService(CommonUtils commonUtils) {
        return (jsonString, headers) -> {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                String uuid = jsonObject.optString("uuid");
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                int argLen = args != null ? args.length() : 0;
                Method method = null;
                if (!mname.isEmpty()) {
                    Method[] ms;
                    for (Method m : ms = commonUtils.getClass().getDeclaredMethods()) {
                        if (!m.getName().equals(mname) || m.getParameterTypes().length != argLen) continue;
                        method = m;
                        break;
                    }
                }
                if (method != null) {
                    Object[] argObjs = null;
                    if (argLen > 0) {
                        argObjs = new Object[argLen];
                    }
                    for (int i = 0; i < argLen; ++i) {
                        Object objArg = args.get(i);
                        if (objArg instanceof JSONArray) {
                            int j;
                            Object[] arrayArg;
                            JSONArray arrayObj = (JSONArray)objArg;
                            if (method.getParameterTypes()[i].isInstance(ARRAY_INT)) {
                                arrayArg = new int[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = arrayObj.getInt(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            if (method.getParameterTypes()[i].isInstance(ARRAY_STRING)) {
                                arrayArg = new String[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = (int)arrayObj.getString(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            arrayArg = new Object[arrayObj.length()];
                            for (j = 0; j < arrayArg.length; ++j) {
                                arrayArg[j] = (int)arrayObj.get(j);
                            }
                            argObjs[i] = arrayArg;
                            continue;
                        }
                        argObjs[i] = objArg;
                    }
                    String jsonResult = null;
                    try {
                        jsonResult = (String)method.invoke((Object)commonUtils, argObjs);
                    }
                    catch (Exception e) {
                        BundleLog.LOG.log(1, e.getMessage(), e);
                        return this.getErrorResponse(e + ". Method: " + mname);
                    }
                    if (uuid.isEmpty()) {
                        return jsonResult;
                    }
                    JSONObject resultObject = new JSONObject(jsonResult);
                    return resultObject.put("uuid", (Object)uuid).toString();
                }
                return this.getErrorResponse("NoSuchMethodException " + mname);
            }
            catch (Exception e) {
                BundleLog.LOG.log(1, e.getMessage(), e);
                return this.getErrorResponse(e.getMessage());
            }
        };
    }

    private ModuleService getModuleService(SignUtils signUtils) {
        return (jsonString, headers) -> {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                String uuid = jsonObject.optString("uuid");
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                int argLen = args != null ? args.length() : 0;
                Method method = null;
                if (!mname.isEmpty()) {
                    Method[] ms;
                    for (Method m : ms = signUtils.getClass().getDeclaredMethods()) {
                        if (!m.getName().equals(mname) || m.getParameterTypes().length != argLen) continue;
                        method = m;
                        break;
                    }
                }
                if (method != null) {
                    Object[] argObjs = null;
                    if (argLen > 0) {
                        argObjs = new Object[argLen];
                    }
                    for (int i = 0; i < argLen; ++i) {
                        Object objArg = args.get(i);
                        if (objArg instanceof JSONArray) {
                            int j;
                            Object[] arrayArg;
                            JSONArray arrayObj = (JSONArray)objArg;
                            if (method.getParameterTypes()[i].isInstance(ARRAY_INT)) {
                                arrayArg = new int[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = arrayObj.getInt(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            if (method.getParameterTypes()[i].isInstance(ARRAY_STRING)) {
                                arrayArg = new String[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = (int)arrayObj.getString(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            arrayArg = new Object[arrayObj.length()];
                            for (j = 0; j < arrayArg.length; ++j) {
                                arrayArg[j] = (int)arrayObj.get(j);
                            }
                            argObjs[i] = arrayArg;
                            continue;
                        }
                        argObjs[i] = objArg;
                    }
                    String jsonResult = null;
                    try {
                        jsonResult = (String)method.invoke((Object)signUtils, argObjs);
                    }
                    catch (Exception e) {
                        BundleLog.LOG.log(1, e.getMessage(), e);
                        return this.getErrorResponse(e + ". Method: " + mname);
                    }
                    if (uuid.isEmpty()) {
                        return jsonResult;
                    }
                    JSONObject resultObject = new JSONObject(jsonResult);
                    return resultObject.put("uuid", (Object)uuid).toString();
                }
                return this.getErrorResponse("NoSuchMethodException " + mname);
            }
            catch (Exception e) {
                BundleLog.LOG.log(1, e.getMessage(), e);
                return this.getErrorResponse(e.getMessage());
            }
        };
    }

    private void getKeyInfoService(BundleContext context, SignUtils signUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.getKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    signUtils.setKeyInfoServices((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            signUtils.setKeyInfoServices(ncalayerservices_accessory);
        }
    }

    private void getKeyInfoSetterService(BundleContext context, SignUtils signUtils) throws Exception {
        String serviceFilter = "(&(objectClass=" + Function.class.getName() + ")(module=kz.gov.pki.ncalayerservices.setKeyInfo))";
        ServiceTracker module_tracker = new ServiceTracker(context, context.createFilter(serviceFilter), (ServiceTrackerCustomizer)null);
        module_tracker.open();
        Function ncalayerservices_accessory = (Function)module_tracker.getService();
        if (ncalayerservices_accessory == null) {
            context.addServiceListener(e -> {
                if (e.getType() == 1) {
                    signUtils.setKeyInfoSetterService((Function)module_tracker.getService(e.getServiceReference()));
                }
            }, serviceFilter);
        } else {
            signUtils.setKeyInfoSetterService(ncalayerservices_accessory);
        }
    }

    private String getErrorResponse(String msg) {
        ResponseMessage responseForJS = new ResponseMessage("500");
        responseForJS.setMessage(msg);
        return JSONObject.wrap(responseForJS).toString();
    }

    private Hashtable<String, String> getModuleProperty(String module) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("module", module);
        return props;
    }
}

