/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo;

import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import javax.swing.UIManager;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.gov.pki.reference.TSAPolicy;
import kz.rating1c.edo.BundleLog;
import kz.rating1c.edo.BundleProvider;
import kz.rating1c.edo.gui.ProgramSettings;
import kz.rating1c.edo.gui.dialog.SignerDialog;
import kz.rating1c.edo.types.ClientException;
import kz.rating1c.edo.types.KeyInfo;
import kz.rating1c.edo.types.ResponseMessage;
import kz.rating1c.edo.types.StorageInfo;
import org.json.JSONObject;

public class SignUtils {
    private Function keyInfoService;
    private Function keyInfoSetterService;
    DateFormat df = new SimpleDateFormat("dd.MM.yyyy (HH:mm)");

    public void setKeyInfoServices(Function keyInfoService) {
        this.keyInfoService = keyInfoService;
    }

    public void setKeyInfoSetterService(Function keyInfoSetterService) {
        this.keyInfoSetterService = keyInfoSetterService;
    }

    public String getActiveTokens() {
        ResponseMessage res = new ResponseMessage("200");
        res.setResponseObject(new ArrayList());
        for (Storage storage : Storage.values()) {
            try {
                if (KeyStoreUtil.loadSlotList((Storage)storage).isEmpty()) continue;
                ((List)res.getResponseObject()).add(storage.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getJson(res);
    }

    public String getKeyInfo(String storageName) {
        ResponseMessage<KeyInfo> res = new ResponseMessage<KeyInfo>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.keyInfoTitle");
            titles.put("actionBtn", "button.signerDialog.keyInfo");
            titles.put("header", "label.signerDialog.infoTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, (KNCACertificateType)null, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                res.setCode("200");
                res.setResponseObject(new KeyInfo(keyStoreEntry, storageInfo.getAlias()));
                if (storageInfo.isNewkey()) {
                    this.saveKey(signerDialog.getSelectedItem(), storageInfo);
                }
            } else {
                res.setMessage("action.canceled");
            }
        }
        catch (Exception var7) {
            BundleLog.LOG.log(1, var7.getMessage(), var7);
            res.setMessage(var7.getMessage());
        }
        return this.getJson(res);
    }

    private void saveKey(KeyStoreEntry keyStoreEntry, StorageInfo storageInfo) {
        try {
            LinkedList<KeyInfo> storedKeys = storageInfo.getStoredKeys();
            KeyInfo storedKey = new KeyInfo();
            storedKey.setPath(storageInfo.getContainer());
            storedKey.setSerial(keyStoreEntry.getSerialNumber());
            storedKey.setIssuerdn(keyStoreEntry.getIssuerCn());
            Set e = X509Util.getKNCACertificateType((X509Certificate)keyStoreEntry.getX509Certificate());
            if (e.contains(KNCACertificateType.AUTHENTICATION)) {
                storedKey.setUsage("\u0414\u043b\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438");
            } else if (e.contains(KNCACertificateType.SIGNATURE)) {
                storedKey.setUsage("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
            }
            storedKey.setSubjectdn(keyStoreEntry.getSubjectCn());
            storedKey.setDatefrom(this.df.format(keyStoreEntry.getX509Certificate().getNotBefore()));
            storedKey.setDateto(this.df.format(keyStoreEntry.getX509Certificate().getNotAfter()));
            boolean save = true;
            String keyString = storedKey.toString();
            for (KeyInfo sk : storedKeys) {
                if (!sk.toString().equals(keyString)) continue;
                save = false;
                break;
            }
            if (save) {
                storedKeys.addFirst(storedKey);
                JSONObject jsonO = new JSONObject();
                jsonO.put("keyInfos", storedKeys);
                this.keyInfoSetterService.apply(jsonO.toString());
            }
        }
        catch (Exception var10) {
            BundleLog.LOG.error(var10.getMessage(), var10);
        }
    }

    public SignUtils() {
        String osname = System.getProperty("os.name").toLowerCase();
        this.df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
        try {
            if (osname.contains("mac os")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception var3) {
            BundleLog.LOG.error(var3.getMessage(), var3);
        }
    }

    public String TestConnect() {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("200");
        responseMessage.setResponseObject("Plugin connected successfully: 1.6.");
        return this.getJson(responseMessage);
    }

    private boolean checkSelectedkeyStoreEntry(KeyStoreEntry keyStoreEntry, StorageInfo storageInfo, String BINControl, Error error) {
        KeyInfo keyInfo;
        boolean isValid = true;
        if (!BINControl.isEmpty() && !(isValid = (keyInfo = new KeyInfo(keyStoreEntry, storageInfo.getAlias())).isKeysOwners(BINControl))) {
            error.AddError("errormessage.certificate.notOwner");
            BundleLog.LOG.log(1, "The certificate is not owned by " + BINControl);
        }
        try {
            keyStoreEntry.getX509Certificate().checkValidity();
        }
        catch (CertificateNotYetValidException varNotYetValidException) {
            isValid = false;
            error.AddError("errormessage.certificate.notYetValid");
        }
        catch (CertificateExpiredException varExpiredException) {
            isValid = false;
            error.AddError("errormessage.certificate.expaired");
        }
        return isValid;
    }

    public String TestKeyOwner(String storageName, String keyTypeValue, String BINControl) {
        ResponseMessage<KeyInfo> responseMessage = new ResponseMessage<KeyInfo>("500");
        try {
            BundleLog.LOG.log(1, "TestKeyOwner Storage create ");
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            KNCACertificateType keyType = null;
            try {
                keyType = KNCACertificateType.valueOf((String)keyTypeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.keyInfoTitle");
            titles.put("actionBtn", "button.signerDialog.sign");
            titles.put("header", "label.signerDialog.infoTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                Error error = new Error();
                Boolean isKeysValid = this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error);
                responseMessage.setCode("200");
                KeyInfo keyInfo = new KeyInfo(keyStoreEntry, storageInfo.getAlias());
                responseMessage.setResponseObject(keyInfo);
                responseMessage.setMessage("IsKeysValid result: " + isKeysValid + ". " + error.getErrorstring());
            }
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            responseMessage.setMessage(e.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String signXml(String storageName, String keyTypeValue, String xml, String tbsElementXPath, String signatureParentElementXPath, String BINControl) {
        ResponseMessage<String> responseMessage = new ResponseMessage<String>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            KNCACertificateType keyType = null;
            try {
                keyType = KNCACertificateType.valueOf((String)keyTypeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.xmlTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                Error error;
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                    responseMessage.setMessage("action.canceled." + error.getErrorstring());
                    return this.getJson(responseMessage);
                }
                SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                responseMessage.setResponseObject(XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xml, (String)tbsElementXPath, (String)signatureParentElementXPath, (Provider)BundleProvider.KALKANCRYPT.getProvider()));
                responseMessage.setCode("200");
            } else {
                responseMessage.setMessage("action.canceled");
            }
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            responseMessage.setMessage(e.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String createCmsFromBase64(String storageName, String keyTypeValue, String base64_data, boolean attached, boolean withTSA, String BINControl) {
        ResponseMessage<String> responseMessage;
        block9: {
            responseMessage = new ResponseMessage<String>("500");
            try {
                StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
                KNCACertificateType keyType = null;
                try {
                    keyType = KNCACertificateType.valueOf((String)keyTypeValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, String> titles = new HashMap<String, String>();
                titles.put("title", "label.signerDialog.cmsTitle");
                SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
                signerDialog.setVisible(true);
                if (signerDialog.getDoSign()) {
                    Error error;
                    KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                    if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                        responseMessage.setMessage("action.canceled." + error.getErrorstring());
                        return this.getJson(responseMessage);
                    }
                    SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                    CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])Base64.getDecoder().decode(base64_data), (boolean)attached, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    if (withTSA) {
                        try {
                            TSAProfile tsaProfile = new TSAProfile();
                            tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
                            tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
                            tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
                            cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                        }
                        catch (ProviderUtilException var8) {
                            BundleLog.LOG.error(var8.getMessage(), var8);
                            throw new ClientException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434: " + var8.getCode().name());
                        }
                    }
                    responseMessage.setResponseObject(Base64.getEncoder().encodeToString(cmsSignedData.getEncoded()));
                    responseMessage.setCode("200");
                    break block9;
                }
                responseMessage.setMessage("action.canceled");
            }
            catch (Exception var14) {
                BundleLog.LOG.log(1, var14.getMessage(), var14);
                responseMessage.setMessage(var14.getMessage());
            }
        }
        return this.getJson(responseMessage);
    }

    public String signXmls(String storageName, String keyTypeValue, String[] xmls, String tbsElementXPath, String signatureParentElementXPath, String BINControl) {
        ResponseMessage<String[]> responseMessage = new ResponseMessage<String[]>("500");
        try {
            StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
            KNCACertificateType keyType = null;
            try {
                keyType = KNCACertificateType.valueOf((String)keyTypeValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("title", "label.signerDialog.xmlTitle");
            SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
            signerDialog.setVisible(true);
            if (signerDialog.getDoSign()) {
                Error error;
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                    responseMessage.setMessage("action.canceled." + error.getErrorstring());
                    return this.getJson(responseMessage);
                }
                SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                String[] signedXmls = new String[xmls.length];
                for (int i = 0; i < xmls.length; ++i) {
                    signedXmls[i] = XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xmls[i], (String)tbsElementXPath, (String)signatureParentElementXPath, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                }
                responseMessage.setResponseObject(signedXmls);
                responseMessage.setCode("200");
            } else {
                responseMessage.setMessage("action.canceled");
            }
        }
        catch (Exception var16) {
            BundleLog.LOG.log(1, var16.getMessage(), var16);
            responseMessage.setMessage(var16.getMessage());
        }
        return this.getJson(responseMessage);
    }

    public String createCmsesFromBase64(String storageName, String keyTypeValue, String[] base64_datas, boolean attached, boolean withTSA, String BINControl) {
        ResponseMessage<String[]> responseMessage;
        block10: {
            responseMessage = new ResponseMessage<String[]>("500");
            try {
                StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
                KNCACertificateType keyType = null;
                try {
                    keyType = KNCACertificateType.valueOf((String)keyTypeValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, String> titles = new HashMap<String, String>();
                titles.put("title", "label.signerDialog.cmsTitle");
                SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
                signerDialog.setVisible(true);
                if (signerDialog.getDoSign()) {
                    Error error;
                    KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                    if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                        responseMessage.setMessage("action.canceled." + error.getErrorstring());
                        return this.getJson(responseMessage);
                    }
                    SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                    String[] cmsSignedDatas = new String[base64_datas.length];
                    for (int i = 0; i < base64_datas.length; ++i) {
                        CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])Base64.getDecoder().decode(base64_datas[i]), (boolean)attached, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                        if (withTSA) {
                            try {
                                TSAProfile tsaProfile = new TSAProfile();
                                tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
                                tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
                                tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
                                cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                            }
                            catch (ProviderUtilException var8) {
                                BundleLog.LOG.error(var8.getMessage(), var8);
                                throw new ClientException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434: " + var8.getCode().name());
                            }
                        }
                        cmsSignedDatas[i] = Base64.getEncoder().encodeToString(cmsSignedData.getEncoded());
                    }
                    responseMessage.setResponseObject(cmsSignedDatas);
                    responseMessage.setCode("200");
                    break block10;
                }
                responseMessage.setMessage("action.canceled");
            }
            catch (Exception var14) {
                BundleLog.LOG.log(1, var14.getMessage(), var14);
                responseMessage.setMessage(var14.getMessage());
            }
        }
        return this.getJson(responseMessage);
    }

    public String createRawsSignFromBase64(String storageName, String keyTypeValue, String[] base64_datas, String BINControl) {
        ResponseMessage<SignResultWithCert> responseMessage;
        block9: {
            responseMessage = new ResponseMessage<SignResultWithCert>("500");
            try {
                StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
                KNCACertificateType keyType = null;
                try {
                    keyType = KNCACertificateType.valueOf((String)keyTypeValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, String> titles = new HashMap<String, String>();
                titles.put("title", "label.signerDialog.rawTitle");
                SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
                signerDialog.setVisible(true);
                if (signerDialog.getDoSign()) {
                    Error error;
                    KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                    if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                        responseMessage.setMessage("action.canceled." + error.getErrorstring());
                        return this.getJson(responseMessage);
                    }
                    SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                    String[] rawSignedDatas = new String[base64_datas.length];
                    String keyAlg = signingEntity.getKey().getAlgorithm();
                    keyAlg = "RSA".equals(keyAlg) ? "SHA256withRSA" : keyAlg;
                    Signature signature = Signature.getInstance(keyAlg, Security.getProvider("KALKAN"));
                    for (int i = 0; i < base64_datas.length; ++i) {
                        byte[] signedData;
                        byte[] data = Base64.getDecoder().decode(base64_datas[i]);
                        try {
                            signature.initSign(signingEntity.getKey());
                            signature.update(data);
                            signedData = signature.sign();
                        }
                        catch (Exception var8) {
                            BundleLog.LOG.error(var8.getMessage(), var8);
                            throw new ClientException(var8.getMessage());
                        }
                        rawSignedDatas[i] = Base64.getEncoder().encodeToString(signedData);
                    }
                    KeyInfo keyInfo = new KeyInfo(keyStoreEntry, storageInfo.getAlias());
                    SignResultWithCert signResultsWithCert = new SignResultWithCert(this.getJson(rawSignedDatas), keyInfo.toString());
                    responseMessage.setResponseObject(signResultsWithCert);
                    responseMessage.setCode("200");
                    break block9;
                }
                responseMessage.setMessage("action.canceled");
            }
            catch (Exception var14) {
                BundleLog.LOG.log(1, var14.getMessage(), var14);
                responseMessage.setMessage(var14.getMessage());
            }
        }
        return this.getJson(responseMessage);
    }

    public String createRawSignFromBase64(String storageName, String keyTypeValue, String base64_data, String BINControl) {
        ResponseMessage<SignResultWithCert> responseMessage;
        block8: {
            responseMessage = new ResponseMessage<SignResultWithCert>("500");
            try {
                StorageInfo storageInfo = new StorageInfo(storageName, this.keyInfoService, this.keyInfoSetterService);
                KNCACertificateType keyType = null;
                try {
                    keyType = KNCACertificateType.valueOf((String)keyTypeValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, String> titles = new HashMap<String, String>();
                titles.put("title", "label.signerDialog.rawTitle");
                SignerDialog signerDialog = new SignerDialog(storageInfo, keyType, titles);
                signerDialog.setVisible(true);
                if (signerDialog.getDoSign()) {
                    byte[] signedData;
                    Error error;
                    KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                    SignerDialog.KeyListEntry keyStoreEntry = signerDialog.getSelectedItem();
                    if (!this.checkSelectedkeyStoreEntry(keyStoreEntry, storageInfo, BINControl, error = new Error())) {
                        responseMessage.setMessage("action.canceled." + error.getErrorstring());
                        return this.getJson(responseMessage);
                    }
                    SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)storageInfo.getAlias(), (char[])storageInfo.getPassword());
                    String keyAlg = signingEntity.getKey().getAlgorithm();
                    KeyInfo keyInfo = new KeyInfo(keyStoreEntry, storageInfo.getAlias());
                    keyAlg = "RSA".equals(keyAlg) ? "SHA256withRSA" : keyAlg;
                    Signature signature = Signature.getInstance(keyAlg, Security.getProvider("KALKAN"));
                    byte[] data = Base64.getDecoder().decode(base64_data);
                    try {
                        signature.initSign(signingEntity.getKey());
                        signature.update(data);
                        signedData = signature.sign();
                    }
                    catch (Exception var8) {
                        throw new ClientException(var8.getMessage());
                    }
                    SignResultWithCert signResultWithCert = new SignResultWithCert(Base64.getEncoder().encodeToString(signedData), keyInfo.toString());
                    responseMessage.setResponseObject(signResultWithCert);
                    responseMessage.setCode("200");
                    break block8;
                }
                responseMessage.setMessage("action.canceled");
            }
            catch (Exception var14) {
                BundleLog.LOG.log(1, var14.getMessage(), var14);
                responseMessage.setMessage(var14.getMessage());
            }
        }
        return this.getJson(responseMessage);
    }

    private String getJson(Object o) {
        return JSONObject.wrap((Object)o).toString();
    }

    public class Error {
        private String ErrorString = "";

        public String getErrorstring() {
            return this.ErrorString;
        }

        public void AddError(String DictionaryTitle) {
            this.ErrorString = this.ErrorString + " " + ProgramSettings.getInstance().getDictionary(DictionaryTitle);
        }
    }

    public class SignResultWithCert {
        private String SignResult;
        private String SignerCert;

        public SignResultWithCert() {
            this.SignResult = "";
            this.SignerCert = "";
        }

        public SignResultWithCert(String SignResult, String SignerCert) {
            this.SignResult = SignResult;
            this.SignerCert = SignerCert;
        }

        public String getSignResult() {
            return this.SignResult;
        }

        public String getSignerCert() {
            return this.SignerCert;
        }

        public void AddSignResult(String SignResult) {
            this.SignResult = SignResult;
        }

        public void AddSignerCert(String SignerCert) {
            this.SignerCert = SignerCert;
        }
    }
}

