/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.gui;

import java.util.Locale;
import java.util.ResourceBundle;

public final class ProgramSettings {
    private static ResourceBundle dictionary;
    private final Locale[] arrayLocales = new Locale[3];
    private final ResourceBundle[] arrayLocalesResource;
    private static ProgramSettings instance;
    private final int defaultLocaleIndex = 0;

    private ProgramSettings() {
        this.arrayLocales[0] = new Locale("ru");
        this.arrayLocales[1] = new Locale("kk");
        this.arrayLocales[2] = new Locale("en");
        int localesCount = this.arrayLocales.length;
        this.arrayLocalesResource = new ResourceBundle[localesCount];
        for (int i = 0; i < localesCount; ++i) {
            this.arrayLocalesResource[i] = ResourceBundle.getBundle("i18n.dictionary", this.arrayLocales[i]);
        }
        this.updateLanguage(0);
    }

    public static ProgramSettings getInstance() {
        if (instance == null) {
            instance = new ProgramSettings();
        }
        return instance;
    }

    public String getDictionary(String key) {
        return dictionary.getString(key);
    }

    public void updateLanguage(int type) {
        dictionary = this.arrayLocalesResource[type];
    }

    public void setLanguage(String language) {
        if (language == null || language.isEmpty()) {
            this.updateLanguage(0);
            return;
        }
        for (int i = 0; i < this.arrayLocales.length; ++i) {
            if (!this.arrayLocales[i].getLanguage().equals(language)) continue;
            this.updateLanguage(i);
            return;
        }
    }

    static {
        instance = null;
    }
}

