/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import kz.rating1c.edo.gui.GUiConstants;
import kz.rating1c.edo.gui.ProgramSettings;
import kz.rating1c.edo.types.KeyInfo;

public class ComboDialog
extends JDialog {
    private final int FRAME_WIDTH = 700;
    private final int FRAME_HEIGHT = 420;
    private JList<KeyInfo> list;
    private List<KeyInfo> keyInfoList;
    private String container;
    private boolean openfileChooser;

    public String getContainer() {
        return this.container;
    }

    public boolean isOpenfileChooser() {
        return this.openfileChooser;
    }

    public ComboDialog(List<KeyInfo> keyInfoList) {
        this.keyInfoList = keyInfoList;
        this.getContentPane().setMaximumSize(new Dimension(700, 420));
        this.getContentPane().add(this.fillContentPane());
        this.setDialogProperties();
    }

    private JPanel fillContentPane() {
        JLabel headerLabel = new JLabel("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043a\u043b\u044e\u0447\u0438");
        headerLabel.setForeground(Color.BLACK);
        headerLabel.setPreferredSize(new Dimension(600, 25));
        headerLabel.setFont(new Font("Tahoma", 1, 14));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setMaximumSize(new Dimension(650, 400));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        DefaultListModel<KeyInfo> listModel = new DefaultListModel<KeyInfo>();
        for (KeyInfo keyInfo : this.keyInfoList) {
            listModel.addElement(keyInfo);
        }
        this.list = new JList(listModel);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        if (this.keyInfoList.size() >= 3) {
            this.list.setVisibleRowCount(3);
        } else {
            this.list.setVisibleRowCount(2);
        }
        this.list.setCellRenderer((l, keyInfox, index, isSelected, cellHasFocus) -> {
            JPanel keyInfoP = new JPanel();
            keyInfoP.setPreferredSize(new Dimension(630, 125));
            if (isSelected) {
                keyInfoP.setBackground(new Color(158, 196, 255));
            } else {
                keyInfoP.setBorder(BorderFactory.createLineBorder(new Color(120, 120, 120), 1));
                keyInfoP.setBackground(Color.WHITE);
            }
            keyInfoP.setToolTipText(keyInfox.getPath());
            keyInfoP.setBounds(0, 0, 630, 125);
            keyInfoP.setLayout(null);
            this.addLabel("label.signerDialog.keyInfo.keyOwner", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 5, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 5, 440, 14), keyInfoP, keyInfox.getSubjectDn());
            this.addTempLabelWithoutDictionary("\u041f\u0443\u0442\u044c:", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 25, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 25, 440, 14), keyInfoP, keyInfox.getPath());
            this.addLabel("label.signerDialog.keyInfo.period", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 45, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 45, 440, 14), keyInfoP, keyInfox.getDatefrom() + " - " + keyInfox.getDateto());
            this.addLabel("label.signerDialog.keyInfo.serialNum", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 65, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 65, 440, 14), keyInfoP, keyInfox.getSerial());
            this.addLabel("label.signerDialog.keyInfo.issuer", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 85, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 85, 440, 14), keyInfoP, keyInfox.getIssuerdn());
            this.addTempLabelWithoutDictionary("\u041f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 105, 174, 14), keyInfoP);
            this.addDynamicTextLabel(new Rectangle(185, 105, 440, 14), keyInfoP, keyInfox.getUsage());
            return keyInfoP;
        });
        this.list.setSelectedIndex(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    KeyInfo keyInfo = (KeyInfo)ComboDialog.this.list.getSelectedValue();
                    ComboDialog.this.container = keyInfo.getPath();
                    ComboDialog.this.closeDialog(null);
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        contentPane.add((Component)listScroller, "Center");
        contentPane.add((Component)headerLabel, "North");
        JButton chooseBtn = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u044e\u0447");
        chooseBtn.setContentAreaFilled(false);
        chooseBtn.setOpaque(true);
        chooseBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        chooseBtn.setFont(new Font("Tahoma", 0, 14));
        chooseBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        chooseBtn.setBorderPainted(false);
        chooseBtn.addActionListener(e -> {
            this.container = null;
            this.openfileChooser = true;
            this.closeDialog(null);
        });
        JButton deleteBtn = new JButton("\u0423\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
        deleteBtn.setContentAreaFilled(false);
        deleteBtn.setOpaque(true);
        deleteBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        deleteBtn.setFont(new Font("Tahoma", 0, 14));
        deleteBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        deleteBtn.setBorderPainted(false);
        deleteBtn.addActionListener(e -> {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex != -1) {
                model.remove(selectedIndex);
                this.keyInfoList.remove(selectedIndex);
            }
        });
        JButton selectBtn = new JButton("\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c");
        selectBtn.setContentAreaFilled(false);
        selectBtn.setOpaque(true);
        selectBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        selectBtn.setFont(new Font("Tahoma", 0, 14));
        selectBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        selectBtn.setBorderPainted(false);
        selectBtn.addActionListener(e -> {
            if (this.list.getSelectedIndex() != -1) {
                KeyInfo keyInfo = this.list.getSelectedValue();
                this.container = keyInfo.getPath();
                this.closeDialog(null);
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new FlowLayout(0, 0, 0));
        actionPanel.add(chooseBtn);
        actionPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        actionPanel.add(deleteBtn);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        bottomPanel.add((Component)actionPanel, "Before");
        bottomPanel.add((Component)selectBtn, "After");
        contentPane.add((Component)bottomPanel, "South");
        return contentPane;
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void addLabel(String key, Color foregroundColor, Rectangle rectangle, JPanel paretnt) {
        JLabel label = key == null ? new JLabel() : new JLabel(ProgramSettings.getInstance().getDictionary(key));
        label.setFont(new Font("Tahoma", 0, 12));
        label.setForeground(foregroundColor);
        label.setBounds(rectangle);
        paretnt.add(label);
    }

    private void addTempLabelWithoutDictionary(String text, Color foregroundColor, Rectangle rectangle, JPanel paretnt) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("Tahoma", 0, 12));
        label.setForeground(foregroundColor);
        label.setBounds(rectangle);
        paretnt.add(label);
    }

    private JTextField addDynamicTextLabel(Rectangle rectangle, JPanel parent, String text) {
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setBorder(null);
        textField.setFont(new Font("Tahoma", 0, 12));
        textField.setBackground(parent.getBackground());
        textField.setBounds(rectangle);
        textField.setText(text);
        parent.add(textField);
        return textField;
    }

    private void setDialogProperties() {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setTitle("\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043b\u044e\u0447\u0435\u0439");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ComboDialog.this.closeDialog(evt);
            }
        });
        this.setFrameToScreenCenter();
        this.setResizable(false);
        this.pack();
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getPreferredSize().width / 2, d.height / 2 - (this.getPreferredSize().height + 232) / 2);
    }
}

