/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.gui.fileChooser;

import javax.swing.JFileChooser;
import javax.swing.UIManager;
import kz.rating1c.edo.gui.ProgramSettings;
import kz.rating1c.edo.gui.fileChooser.FileChooserFilter;

public final class FileChooser
extends JFileChooser {
    private FileType currentFileType;
    private final FileChooserFilter keyFilter = new FileChooserFilter();

    public FileChooser(FileType fileType) {
        this.setFileType(fileType);
        this.setFileFilter(this.keyFilter);
        if (String.valueOf((Object)fileType).equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateLanguage();
    }

    public FileChooser(String fileType) {
        if (fileType == null || fileType.isEmpty()) {
            this.setFileType(FileType.DIRECTORY);
        } else {
            this.setFileType(FileType.valueOf(fileType));
        }
        this.setFileFilter(this.keyFilter);
        if (fileType.equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateLanguage();
    }

    public void setFileType(FileType fileType) {
        this.currentFileType = fileType;
        this.keyFilter.clearExtension();
        switch (fileType) {
            case DIRECTORY: {
                this.keyFilter.addExtension("");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.directory"));
                this.setFileSelectionMode(1);
                break;
            }
            case CER: {
                this.keyFilter.addExtension("der");
                this.keyFilter.addExtension("cer");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.cer"));
                this.setFileSelectionMode(0);
                break;
            }
            case CRL: {
                this.keyFilter.addExtension("crl");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.crl"));
                this.setFileSelectionMode(0);
                break;
            }
            case P12: {
                this.keyFilter.addExtension("p12");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case JKS: {
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case KEYSTORE: {
                this.keyFilter.addExtension("pfx");
                this.keyFilter.addExtension("p12");
                this.keyFilter.addExtension("bin");
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case ALL: {
                this.keyFilter.addExtension("*");
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.file"));
                this.setFileSelectionMode(0);
            }
        }
    }

    public void updateLanguage() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.setDialogTitle(" " + ProgramSettings.getInstance().getDictionary("fileChooser.title.directory"));
                break;
            }
            default: {
                this.setDialogTitle(" " + ProgramSettings.getInstance().getDictionary("fileChooser.title.file"));
            }
        }
        UIManager.put("FileChooser.openButtonText", ProgramSettings.getInstance().getDictionary("fileChooser.openButtonText"));
        UIManager.put("FileChooser.saveButtonText", ProgramSettings.getInstance().getDictionary("fileChooser.saveButtonText"));
        UIManager.put("FileChooser.cancelButtonText", ProgramSettings.getInstance().getDictionary("fileChooser.cancelButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.saveButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.saveButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.cancelButtonToolTipText"));
        UIManager.put("FileChooser.lookInLabelText", ProgramSettings.getInstance().getDictionary("fileChooser.lookInLabelText"));
        UIManager.put("FileChooser.saveInLabelText", ProgramSettings.getInstance().getDictionary("fileChooser.saveInLabelText"));
        UIManager.put("FileChooser.fileNameLabelText", ProgramSettings.getInstance().getDictionary("fileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", ProgramSettings.getInstance().getDictionary("fileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.upFolderToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.upFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.homeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.directoryOpenButtonText", ProgramSettings.getInstance().getDictionary("fileChooser.directoryOpenButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", ProgramSettings.getInstance().getDictionary("fileChooser.directoryOpenButtonToolTipText"));
        this.updateDescription();
        this.updateUI();
    }

    public void updateDescription() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.directory"));
                break;
            }
            case CRL: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.crl"));
                break;
            }
            case CER: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.cer"));
                break;
            }
            case P12: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                break;
            }
            case JKS: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                break;
            }
            case KEYSTORE: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.key"));
                break;
            }
            default: {
                this.keyFilter.setDescription(ProgramSettings.getInstance().getDictionary("fileChooser.description.file"));
            }
        }
    }

    public static enum FileType {
        DIRECTORY,
        CRL,
        CER,
        P12,
        KEYSTORE,
        JKS,
        ALL;

    }
}

