/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.gui.fileChooser;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private Hashtable<Object, Object> filters = null;
    private String description = null;
    private String fullDescription = null;
    private final boolean useExtensionsInDescription = true;

    @Override
    public boolean accept(File f) {
        String extension = null;
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            extension = this.getExtension(f);
            return extension != null && this.filters.get(this.getExtension(f)) != null;
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration<Object> extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "*." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public void clearExtension() {
        this.filters = new Hashtable();
        this.description = null;
        this.fullDescription = null;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public boolean isExtensionListInDescription() {
        return true;
    }
}

