/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.types;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.rating1c.edo.BundleLog;
import org.json.JSONObject;

public class KeyInfo {
    private String alias;
    private String keyId;
    private String algorithm;
    private String subjectCn;
    private String issuerCn;
    private String issuerDn;
    private String serialNumber;
    private String certNotAfter;
    private String certNotBefore;
    private String subjectDn;
    private String subjectIIN;
    private String subjectBIN;
    private String path;
    private String authorityKeyIdentifier;
    private String pem;
    private String usage;

    public KeyInfo() {
        this.alias = "";
        this.algorithm = "";
        this.subjectCn = "";
        this.issuerCn = "";
        this.subjectIIN = "";
        this.subjectBIN = "";
    }

    public KeyInfo(String jsonString) {
        this.alias = "";
        this.algorithm = "";
        this.subjectCn = "";
        this.issuerCn = "";
        this.subjectIIN = "";
        this.subjectBIN = "";
        JSONObject kiObj = new JSONObject(jsonString);
        this.path = kiObj.optString("path");
        this.subjectDn = kiObj.optString("subjectdn");
        this.issuerDn = kiObj.optString("issuerdn");
        this.serialNumber = kiObj.optString("serial");
        this.usage = kiObj.optString("usage");
        this.certNotBefore = kiObj.optString("datefrom");
        this.certNotAfter = kiObj.optString("dateto");
    }

    public KeyInfo(KeyStoreEntry keyStoreEntry, String alias) {
        X509Certificate certificate = keyStoreEntry.getX509Certificate();
        this.alias = alias;
        this.subjectCn = keyStoreEntry.getSubjectCn();
        this.algorithm = keyStoreEntry.getAlgorithm();
        this.issuerCn = keyStoreEntry.getIssuerCn();
        this.serialNumber = keyStoreEntry.getSerialNumber();
        this.certNotAfter = String.valueOf(certificate.getNotAfter().getTime());
        this.certNotBefore = String.valueOf(certificate.getNotBefore().getTime());
        this.issuerDn = String.valueOf(certificate.getIssuerDN().getName());
        this.subjectDn = certificate.getSubjectX500Principal().toString();
        String dn = certificate.getSubjectX500Principal().getName();
        LdapName ldapDN = null;
        try {
            ldapDN = new LdapName(dn);
        }
        catch (InvalidNameException e) {
            BundleLog.LOG.log(1, "KeyInfo klass: 3. ldaP ERROR: ", e);
        }
        String BIN = "";
        String IIN = "";
        for (Rdn rdn : ldapDN.getRdns()) {
            if (rdn.getType().equalsIgnoreCase("OU")) {
                BIN = rdn.getValue().toString();
            }
            if (!rdn.getType().equalsIgnoreCase("serialNumber") && !rdn.getType().equalsIgnoreCase("2.5.4.5")) continue;
            IIN = new String((byte[])rdn.getValue());
        }
        this.subjectBIN = BIN.replace("BIN", "");
        this.subjectIIN = IIN.substring(IIN.length() - 12);
        try {
            this.keyId = X509Util.getKeyId((X509Certificate)certificate);
            this.authorityKeyIdentifier = Hex.encodeStr((byte[])X509Util.getAuthorityKeyIdentifier((X509Extension)certificate));
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
        }
        try {
            this.pem = X509Util.getPem((X509Certificate)keyStoreEntry.getX509Certificate());
        }
        catch (IOException e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
        }
    }

    public boolean isKeysOwners(String bin_iin) {
        if (this.subjectBIN != null && this.subjectBIN.length() == 12) {
            return this.subjectBIN.equals(bin_iin);
        }
        if (this.subjectIIN != null && this.subjectIIN.length() == 12) {
            return this.subjectIIN.equals(bin_iin);
        }
        BundleLog.LOG.log(1, "BIN: " + this.subjectBIN + "IIN: " + this.subjectIIN + " doesn't belong to: " + bin_iin);
        return false;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSubjectCn() {
        return this.subjectCn;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public String getSerial() {
        return this.serialNumber;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getIssuerCn() {
        return this.issuerCn;
    }

    public String getIssuerdn() {
        return this.issuerDn;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertNotAfter() {
        return this.certNotAfter;
    }

    public String getCertNotBefore() {
        return this.certNotBefore;
    }

    public String getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public String getPem() {
        return this.pem;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "KeyInfo(alias=" + this.getAlias() + ", keyId=" + this.getKeyId() + ", algorithm=" + this.getAlgorithm() + ", subjectCn=" + this.getSubjectCn() + ", subjectDn=" + this.getSubjectDn() + ", issuerCn=" + this.getIssuerCn() + ", issuerDn=, serialNumber=" + this.getSerialNumber() + ", certNotAfter=" + this.getCertNotAfter() + ", certNotBefore=" + this.getCertNotBefore() + ", authorityKeyIdentifier=" + this.getAuthorityKeyIdentifier() + ", pem=" + this.getPem() + ")";
    }

    public String toJsonString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("path", (Object)this.path);
        object.put("subjectdn", (Object)this.getSubjectDn());
        object.put("issuerdn", (Object)this.getIssuerdn());
        object.put("serial", (Object)this.getSerial());
        object.put("usage", (Object)this.usage);
        object.put("datefrom", (Object)this.getDatefrom());
        object.put("dateto", (Object)this.getDateto());
        return object;
    }

    public String getDatefrom() {
        return this.certNotBefore;
    }

    public String getDateto() {
        return this.certNotAfter;
    }

    public void setDatefrom(String datefrom) {
        this.certNotAfter = datefrom;
    }

    public void setDateto(String dateto) {
        this.certNotBefore = dateto;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSerial(String serial) {
        this.serialNumber = serial;
    }

    public void setIssuerdn(String issuerdn) {
        this.issuerDn = issuerdn;
    }

    public void setSubjectdn(String subjectdn) {
        this.subjectDn = subjectdn;
    }
}

