/*
 * Decompiled with CFR 0.152.
 */
package kz.rating1c.edo.types;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.smartcardio.CardException;
import javax.swing.JFrame;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.rating1c.edo.BundleLog;
import kz.rating1c.edo.gui.dialog.ComboDialog;
import kz.rating1c.edo.gui.fileChooser.FileChooserDialog;
import kz.rating1c.edo.types.ClientException;
import kz.rating1c.edo.types.KeyInfo;
import org.json.JSONArray;
import org.json.JSONObject;

public class StorageInfo {
    private String alias;
    private String container;
    private char[] password;
    private KeyStore keyStore;
    private Storage storage;
    private List<String> containers;
    private LinkedList<KeyInfo> storedKeys = new LinkedList();
    private boolean newkey;

    public StorageInfo(String storageName, Function<String, String> keyInfoGetterService, Function<String, String> keyInfoSetterService) throws ClientException {
        if (storageName != null && !storageName.trim().isEmpty()) {
            this.storage = Storage.get((String)storageName);
            if (this.storage == null) {
                throw new ClientException("storage.unknown");
            }
            if (this.storage.isToken() && this.getContainers() == null) {
                throw new ClientException("storage.empty");
            }
            if (!this.storage.isToken()) {
                this.fillStoredKeys(keyInfoGetterService);
                if (this.storedKeys.size() > 0) {
                    int keys_cnt = this.storedKeys.size();
                    ComboDialog comboDialog = new ComboDialog(this.storedKeys);
                    comboDialog.setVisible(true);
                    if (comboDialog.isOpenfileChooser()) {
                        this.container = this.chooseFile();
                        this.newkey = true;
                    } else {
                        this.container = comboDialog.getContainer();
                    }
                    if (this.storedKeys.size() < keys_cnt) {
                        JSONObject jsonO = new JSONObject();
                        jsonO.put("keyInfos", this.storedKeys);
                        keyInfoSetterService.apply(jsonO.toString());
                    }
                } else {
                    this.container = this.chooseFile();
                    this.newkey = true;
                }
                if (this.container == null) {
                    throw new ClientException("action.canceled");
                }
            } else {
                this.container = this.getContainers().get(0);
            }
        } else {
            throw new ClientException("storageName.param.empty");
        }
    }

    private void fillStoredKeys(Function<String, String> keyInfoGetterService) {
        try {
            JSONObject jsonObject = new JSONObject(keyInfoGetterService.apply(""));
            JSONArray objects = jsonObject.optJSONArray("keyInfos");
            if (objects != null) {
                for (Object o : objects) {
                    KeyInfo sk = new KeyInfo(o.toString());
                    this.storedKeys.add(sk);
                }
            }
        }
        catch (Exception var7) {
            BundleLog.LOG.error(var7.getMessage(), var7);
        }
    }

    public List<String> getContainers() {
        if (this.containers == null && this.storage.isToken()) {
            try {
                for (String tName : KeyStoreUtil.loadSlotList((Storage)this.storage)) {
                    if (this.containers == null) {
                        this.containers = new ArrayList<String>();
                    }
                    this.containers.add(tName);
                }
            }
            catch (CardException | KalkanException | ProviderUtilException var3) {
                BundleLog.LOG.error(var3.getMessage(), var3);
            }
        }
        return this.containers;
    }

    public StorageInfo(String storageName) throws ClientException {
        if (storageName == null || storageName.trim().isEmpty()) {
            throw new ClientException("storageName.param.empty");
        }
        this.storage = Storage.get((String)storageName);
        if (this.storage == null) {
            throw new ClientException("storage.unknown");
        }
        if (this.storage.isToken() && this.getContainers() == null) {
            throw new ClientException("storage.empty");
        }
        this.container = !this.storage.isToken() ? this.chooseFile() : this.getContainers().get(0);
    }

    private String chooseFile() throws ClientException {
        FileChooserDialog fileChooserDialog = new FileChooserDialog(new JFrame(), this.storage.equals((Object)Storage.PKCS12) ? "P12" : "ALL", "");
        if (fileChooserDialog.getSelectedFilePath() != null) {
            return fileChooserDialog.getSelectedFilePath();
        }
        throw new ClientException("action.canceled");
    }

    public String getAlias() {
        return this.alias;
    }

    public String getContainer() {
        return this.container;
    }

    public char[] getPassword() {
        return this.password;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public LinkedList<KeyInfo> getStoredKeys() {
        return this.storedKeys;
    }

    public boolean isNewkey() {
        return this.newkey;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setContainers(List<String> containers) {
        this.containers = containers;
    }

    public void setStoredKeys(LinkedList<KeyInfo> storedKeys) {
        this.storedKeys = storedKeys;
    }

    public void setNewkey(boolean newkey) {
        this.newkey = newkey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageInfo)) {
            return false;
        }
        StorageInfo other = (StorageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$container = this.getAlias();
        String other$container = other.getAlias();
        if (!(this$container == null ? other$container == null : this$container.equals(other$container))) {
            return false;
        }
        this$container = this.getContainer();
        other$container = other.getContainer();
        if (this$container == null ? other$container != null : !this$container.equals(other$container)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        KeyStore this$keyStore = this.getKeyStore();
        KeyStore other$keyStore = other.getKeyStore();
        if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
            return false;
        }
        Storage this$storage = this.getStorage();
        Storage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        List<String> this$containers = this.getContainers();
        List<String> other$containers = other.getContainers();
        if (this$containers == null ? other$containers != null : !((Object)this$containers).equals(other$containers)) {
            return false;
        }
        LinkedList<KeyInfo> this$storedKeys = this.getStoredKeys();
        LinkedList<KeyInfo> other$storedKeys = other.getStoredKeys();
        if (this$storedKeys == null ? other$storedKeys != null : !((Object)this$storedKeys).equals(other$storedKeys)) {
            return false;
        }
        return this.isNewkey() == other.isNewkey();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageInfo;
    }

    public int hashCode() {
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : $container.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        KeyStore $keyStore = this.getKeyStore();
        result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
        Storage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        List<String> $containers = this.getContainers();
        result = result * 59 + ($containers == null ? 43 : $containers.hashCode());
        LinkedList<KeyInfo> $storedKeys = this.getStoredKeys();
        result = result * 59 + ($storedKeys == null ? 43 : $storedKeys.hashCode());
        result = result * 59 + (this.isNewkey() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "StorageInfo(alias=" + this.getAlias() + ", container=" + this.getContainer() + ", password=" + Arrays.toString(this.getPassword()) + ", keyStore=" + this.getKeyStore() + ", storage=" + this.getStorage() + ", containers=" + this.getContainers() + ", storedKeys=" + this.getStoredKeys() + ", newkey=" + this.isNewkey() + ")";
    }
}

